# Action Pack for User Management

## [User management](./UserManagement)
 +  Solutions and sample scripts for on and off boarding operations
<hr />

+ [Get-CovidData.ps1](./Get-CovidData.ps1)

  The hourly updated statistic about Coronavirus. 
  Stats by country are collected from several reliable sources<br>
  Watch our video at https://www.youtube.com/watch?v=VqlxbyWilf0 to learn how to configure the ScriptRunner Action

+ [Active Directory - Reset-ADUserPassword.ps1](../ActiveDirectory/Users/Reset-ADUserPassword.ps1)

  Resets the password of the Active Directory account

+ [Azure AD - Reset-AADUserPassword.ps1](../O365/AzureAD/Users/Reset-AADUserPassword.ps1)

  Connect to Azure Active Directory and resets the password from the user

+ [Exchange - Set-ExOutOfOffice.ps1](../Exchange/MailBoxes/Set-ExOutOfOffice.ps1)

  Connect to Microsoft Exchange Server and enable or disable Automatic Replies for one or more specified mailboxes

+ [Exchange - Get-ExMailboxActiveSync.ps1](../Exchange/MailBoxes/Get-ExMailboxActiveSync.ps1)

  Connect to Microsoft Exchange Server and gets the mailbox ActiveSync setting

+ [Exchange - Set-ExMailboxActiveSync.ps1](../Exchange/MailBoxes/Set-ExMailboxActiveSync.ps1)

  Connect to Microsoft Exchange Server and sets the mailbox ActiveSync setting

+ [Exchange Online - Set-EOOutOfOffice.ps1](../O365/ExchangeOnline/MailBoxes/Set-EOOutOfOffice.ps1)

  Connect to Exchange Online and enable or disable Automatic Replies for one or more specified mailboxes

+ [Exchange Online - Get-EOMailboxActiveSync.ps1](../O365/ExchangeOnline/MailBoxes/Get-EOMailboxActiveSync.ps1)

  Connect to Exchange Online and gets the mailbox ActiveSync setting to mailbox

+ [Exchange Online - Set-EOMailboxActiveSync.ps1](../O365/ExchangeOnline/MailBoxes/Set-EOMailboxActiveSync.ps1)

  Connect to Exchange Online and sets the mailbox ActiveSync setting to mailbox

+ [MS-Teams - New-MSTTeam.ps1](../O365/MS-Teams/Teams/New-MSTTeam.ps1)

  Creates a new Team for use in Microsoft Teams and will create an O365 Unified Group to back the team

+ [MS-Teams - Get-MSTTeamsStatistic_Html.ps1](../O365/MS-Teams/_REPORTS_/Get-MSTTeamsStatistic_html.ps1)

  Retrieving teams informations

+ [MS-Teams - Clear-MSTCache.ps1](../O365/MS-Teams/Common/Clear-MSTCache.ps1)

  Clears the Microsoft Teams client cache